/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.command;

import com.andavin.images.Images;
import com.andavin.images.command.BaseCommand;
import com.andavin.images.image.CustomImage;
import com.andavin.util.ActionBarUtil;
import com.andavin.util.LocationUtil;
import com.andavin.util.Logger;
import com.andavin.util.MinecraftVersion;
import com.andavin.util.Scheduler;
import com.google.common.base.Preconditions;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

final class CreateCommand
extends BaseCommand
implements Listener {
    private static final Predicate<String> URL_TEST = Pattern.compile("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]").asPredicate();
    private final Map<UUID, CreateImageTask> creating = new HashMap<UUID, CreateImageTask>();

    CreateCommand() {
        super("create", "images.command.create");
        this.setAliases("new", "add", "load");
        this.setMinimumArgs(1);
        this.setUsage("/image create <image name> [scale percent]");
        this.setDesc("Create and begin pasting a new custom image");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Images.getInstance());
    }

    @Override
    public void execute(Player player, String label, String[] args) {
        double scale;
        Supplier<String> nameSupplier;
        ImageSupplier imageSupplier;
        String imageNameArg = args[0];
        if (URL_TEST.test(imageNameArg)) {
            AtomicReference fileName = new AtomicReference();
            imageSupplier = () -> {
                URI uri = new URI(imageNameArg);
                int slash = imageNameArg.lastIndexOf(47);
                fileName.set(slash == -1 ? imageNameArg : imageNameArg.substring(slash + 1));
                return ImageIO.read(uri.toURL());
            };
            nameSupplier = fileName::get;
        } else {
            File imageFile = Images.getImageFile(imageNameArg);
            imageSupplier = () -> ImageIO.read(imageFile);
            nameSupplier = imageFile::getName;
        }
        if (args.length > 1) {
            try {
                scale = Double.parseDouble(args[1]) / 100.0;
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7cInvalid scale \u00a7f" + args[1]);
                return;
            }
            if (scale < 0.01) {
                player.sendMessage("\u00a7cScale must be more than 1%, but got \u00a7f" + scale * 100.0 + '%');
                return;
            }
        } else {
            scale = 1.0;
        }
        UUID id = player.getUniqueId();
        this.creating.put(id, new CreateImageTask(scale, imageSupplier, nameSupplier));
        Scheduler.repeatAsyncWhile(() -> ActionBarUtil.sendActionBar(player, "\u00a7eRight Click to place\u00a77 - \u00a7eLeft Click to cancel"), 5L, 20L, () -> this.creating.containsKey(id));
    }

    @Override
    public void tabComplete(CommandSender sender, String[] args, List<String> completions) {
        if (args.length == 1) {
            Images.getImageFiles().forEach(file -> {
                String name = file.getName();
                if (StringUtils.startsWithIgnoreCase((String)name, (String)args[0])) {
                    completions.add(name.replace(' ', '_'));
                }
            });
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        CreateImageTask task = this.creating.remove(player.getUniqueId());
        if (task == null) {
            return;
        }
        switch (event.getAction()) {
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                Location location;
                BlockFace direction;
                event.setCancelled(true);
                Location playerLocation = player.getLocation();
                if (event.getClickedBlock() != null) {
                    direction = event.getBlockFace();
                    Block block = event.getClickedBlock().getRelative(direction);
                    location = block.getLocation();
                    location.setYaw(playerLocation.getYaw());
                    location.setPitch(playerLocation.getPitch());
                } else {
                    direction = LocationUtil.getDirection(playerLocation, false, true).getOppositeFace();
                    location = playerLocation.clone();
                    switch (direction) {
                        case UP: {
                            break;
                        }
                        case DOWN: {
                            location.add(0.0, 2.0, 0.0);
                            break;
                        }
                        default: {
                            location.add(0.0, 1.0, 0.0);
                        }
                    }
                }
                if (direction == BlockFace.SELF || MinecraftVersion.lessThan(MinecraftVersion.v1_13)) {
                    switch (direction) {
                        case UP: 
                        case DOWN: 
                        case SELF: {
                            player.sendMessage("\u00a7cUnsupported direction!");
                            return;
                        }
                    }
                }
                Scheduler.async(() -> {
                    player.sendMessage("\u00a7aStarting image paste");
                    BufferedImage image = task.readImage();
                    if (image == null) {
                        player.sendMessage("\u00a7cInvalid image file! Please choose another.");
                        return;
                    }
                    CustomImage customImage = new CustomImage(player.getUniqueId(), (String)task.nameSupplier.get(), location, direction, image);
                    customImage.refresh(player, playerLocation);
                    if (Images.addImage(customImage)) {
                        player.sendMessage("\u00a7aSuccessfully created image\u00a7f " + customImage.getImageName());
                    } else {
                        player.sendMessage("\u00a7cFailed to create image at that location");
                    }
                });
                break;
            }
            case LEFT_CLICK_AIR: 
            case LEFT_CLICK_BLOCK: {
                event.setCancelled(true);
                player.sendMessage("\u00a7cCreation cancelled");
            }
        }
    }

    @EventHandler
    public void onAnimate(PlayerAnimationEvent event) {
        Player player = event.getPlayer();
        if (this.creating.remove(player.getUniqueId()) != null) {
            player.sendMessage("\u00a7cCreation cancelled");
        }
    }

    private static interface ImageSupplier {
        public BufferedImage get() throws Exception;
    }

    private static class CreateImageTask {
        private final double scale;
        private final ImageSupplier imageSupplier;
        private final Supplier<String> nameSupplier;

        CreateImageTask(double scale, ImageSupplier supplier, Supplier<String> nameSupplier) {
            Preconditions.checkArgument((scale > 0.0 ? 1 : 0) != 0, (String)"\u00a7cScale must be greater than zero\u00a7f %s", (Object[])new Object[]{scale});
            this.scale = scale;
            this.nameSupplier = nameSupplier;
            this.imageSupplier = (ImageSupplier)Preconditions.checkNotNull((Object)supplier);
        }

        BufferedImage readImage() {
            try {
                BufferedImage image = this.imageSupplier.get();
                if (this.scale == 1.0) {
                    return image;
                }
                Image scaled = image.getScaledInstance((int)Math.ceil((double)image.getWidth() * this.scale), (int)Math.ceil((double)image.getHeight() * this.scale), 4);
                BufferedImage other = new BufferedImage(scaled.getWidth(null), scaled.getHeight(null), 2);
                Graphics2D graphics = other.createGraphics();
                graphics.drawImage(scaled, 0, 0, null);
                graphics.dispose();
                return other;
            }
            catch (Exception e) {
                Logger.debug(e);
                return null;
            }
        }
    }
}

